// mdNameExample.java
//
// Melissa Data mdName API for Java
// Copyright 1993-2007 Melissa Data Corporation.

//********************************************************************************
//If you should have any comments, suggestions or improvements to these samples,
//we welcome you to contact us at SampleCode@melissadata.com also please visit our
//developers bulletin board at forum.melissadata.com.
//********************************************************************************


import com.melissadata.*;
import java.io.*;



public class mdNameExample {

	/*********************** DATA FILE PATH  ***********************
	   File location path is set to the default Data File location. 
	   Change this value if you installed the data files to a       
	   different folder. The Data Files Directory must contain      
	   mdName.dat and optionally, mdName.cfg (to override the .dat)
    ***************************************************************/
	public static final String dFILELOC="C:/Program Files/Melissa DATA/DQT/Data";

	/********************** LICENSE STRINGS **********************
	     You will need a valid license string to use Name Object,   
	    please call a sales representative at 1-800-MELISSA ext. 3 
	         (1-800-635-4772 x3) for a license string, then          
	             REPLACE "DEMO" with your LICENSE STRING                    

	    SetLicenseString will also check for a valid license in  
	    the MDNAME_LICENSE(Environment) variable. This allows you   
	    to modify the license without recompiling the project
    **************************************************************/
	public static final String dLICENSE="DEMO";

	public static void main(String Args[]) throws IOException {
		int Record=0;
		char Chr;
		String FullName;
		String ResultsString;

    System.out.println("");
    System.out.println("===================================");
    System.out.println("      NAME OBJECT JAVA EXAMPLE   ");
    System.out.println("===================================");
    System.out.println("");
    
		mdName Name=new mdName();
		if (Name.SetLicenseString(dLICENSE)==0) {
			System.out.println(String.format("Error setting License to %1$s",
				dLICENSE));
			System.out.println("Please contact a Melissa Data sales representative");
			System.out.println("at 1-800-800-6245 x3 for a valid license string.");
			return;
		}
		
		Name.SetPathToNameFiles(dFILELOC);
		if (Name.InitializeDataFiles()!= mdName.ProgramStatus.NoError) {
			System.out.println(String.format("Error initializing mdName: \"%1$s\"",
				Name.GetInitializeErrorString()));
			return;
		}

    System.out.println(String.format("            Build Number: %1$s",Name.GetBuildNumber()));
    System.out.println(String.format("           Database Date: %1$s",Name.GetDatabaseDate()));
    System.out.println(String.format("Database Expiration Date: %1$s",Name.GetDatabaseExpirationDate()));
    System.out.println(String.format(" License Expiration Date: %1$s",Name.GetLicenseExpirationDate()));
    

		// Set a few processing options:
		Name.SetPrimaryNameHint(mdName.NameHints.VeryLikelyFull);
		Name.SetFirstNameSpellingCorrection(1);
		Name.SetSalutationPrefix("Dear");
		Name.SetSalutationSuffix(":");
		Name.SetSalutationSlug("Valued Customer");

    String input = "";
		BufferedReader stdin = new BufferedReader( new InputStreamReader( System.in ) );
		while (!input.equals("X"))
		{

			System.out.print("\nEnter FullName: ");
			FullName = stdin.readLine();
			
				Name.ClearProperties();
				Name.SetFullName(FullName);
				Name.Parse();

				Record++;
				System.out.println(String.format("Record %1$d Full Name: %2$s\n"+
					"            Gender1: %3$s\n            Prefix1: %4$s\n"+
					"        First Name1: %5$s\n       Middle Name1: %6$s\n"+
					"         Last Name1: %7$s\n            Suffix1: %8$s\n"+
					"            Gender2: %9$s\n            Prefix2: %10$s\n"+
					"        First Name2: %11$s\n       Middle Name2: %12$s\n"+
					"         Last Name2: %13$s\n            Suffix2: %14$s\n"+
					"         Salutation: %15$s\n\n",
				  Record,FullName,Name.GetGender(),Name.GetPrefix(),
				  Name.GetFirstName(),Name.GetMiddleName(),Name.GetLastName(),
				  Name.GetSuffix(),Name.GetGender2(),Name.GetPrefix2(),
				  Name.GetFirstName2(),Name.GetMiddleName2(),Name.GetLastName2(),
				  Name.GetSuffix2(),Name.GetSalutation()));
				  
				ResultsString=Name.GetResults();
        if(ResultsString.contains("NS01"))
					System.out.println("NS01: There were no errors.");
				if(ResultsString.contains("NS03"))
					System.out.println("NS03: The spelling of the FirstName field was corrected");
				if(ResultsString.contains("NS04"))
					System.out.println("NS04: The spelling of the FirstName2 field was corrected");	

        if(ResultsString.contains("NS02"))
					System.out.println("NS02: A parse error was found...");
				if(ResultsString.contains("NE01"))
					System.out.println("NE01: Two names were detected but the FullName string was not in a recognized format");
				if(ResultsString.contains("NE02"))
					System.out.println("NE02: Multiple first names  could not accurately genderize");
				if(ResultsString.contains("NE03"))
					System.out.println("NE03: A vulgarity was detected in the name");
				if(ResultsString.contains("NE04"))
					System.out.println("NE04: A nuisance name [such as Mickey Mouse] was detected in the name");
				if(ResultsString.contains("NE05"))
					System.out.println("NE05: The name contained words normally found in a company name");
				if(ResultsString.contains("NE06"))
					System.out.println("NE06: The named contained a non-alphabetic character");
				
				System.out.print("\nPress Enter to Continue, X to quit: ");
			
			input = stdin.readLine().toUpperCase();

			}
			
		return;
	}
}